/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class MMView
extends JFrame
implements ActionListener,
Printable {
    private JToolBar toolBar;
    private JLabel statusBar;
    private JTextArea textArea;
    private JFileChooser fileChooser = new JFileChooser();
    private Container cnt;

    MMView() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(this.fileChooser);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setTitle("MMEditor-\u65b0\u898f\u6587\u66f8");
        this.InitMenuBar();
        this.InitToolBar();
        this.InitStatusBar();
        this.InitTextArea(400, 500);
        this.setDefaultCloseOperation(3);
        this.setBounds(200, 200, 450, 700);
        this.textArea.grabFocus();
        this.setVisible(true);
    }

    void InitMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        this.getRootPane().setJMenuBar(menuBar);
        JMenu menuFile = new JMenu("\u30d5\u30a1\u30a4\u30eb(F)");
        menuFile.setMnemonic('F');
        menuBar.add(menuFile);
        JMenuItem menuOpen = new JMenuItem("\u958b\u304f(O)...");
        menuOpen.setMnemonic('O');
        menuOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        menuOpen.setActionCommand("ToText");
        menuOpen.addActionListener(this);
        menuFile.add(menuOpen);
        JMenuItem menuSaveAs = new JMenuItem(".txt\u4fdd\u5b58(A)...");
        menuSaveAs.setMnemonic('A');
        menuSaveAs.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        menuSaveAs.setActionCommand("SaveAs");
        menuSaveAs.addActionListener(this);
        menuFile.add(menuSaveAs);
        JMenuItem menuSave = new JMenuItem(".mm\u4fdd\u5b58(S)");
        menuSave.setMnemonic('S');
        menuSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        menuSave.setActionCommand("ToMM");
        menuSave.addActionListener(this);
        menuFile.add(menuSave);
        JMenuItem menuPrint = new JMenuItem("\u5370\u5237(P)...");
        menuPrint.setMnemonic('P');
        menuPrint.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        menuPrint.setActionCommand("Print");
        menuPrint.addActionListener(this);
        menuFile.add(menuPrint);
        JMenuItem menuExit = new JMenuItem("\u7d42\u4e86(X)");
        menuExit.setMnemonic('X');
        menuExit.setActionCommand("Exit");
        menuExit.addActionListener(this);
        menuFile.add(menuExit);
        JMenu menuEdit = new JMenu("\u7de8\u96c6(E)");
        menuEdit.setMnemonic('E');
        menuBar.add(menuEdit);
        JMenuItem menuCut = new JMenuItem("\u5207\u308a\u53d6\u308a(T)");
        menuCut.setMnemonic('T');
        menuCut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        menuCut.setActionCommand("Cut");
        menuCut.addActionListener(this);
        menuEdit.add(menuCut);
        JMenuItem menuCopy = new JMenuItem("\u30b3\u30d4\u30fc(C)");
        menuCopy.setMnemonic('C');
        menuCopy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        menuCopy.setActionCommand("Copy");
        menuCopy.addActionListener(this);
        menuEdit.add(menuCopy);
        JMenuItem menuPaste = new JMenuItem("\u8cbc\u308a\u4ed8\u3051(P)");
        menuPaste.setMnemonic('P');
        menuPaste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        menuPaste.setActionCommand("Paste");
        menuPaste.addActionListener(this);
        menuEdit.add(menuPaste);
        JMenu menuView = new JMenu("\u8868\u793a(V)");
        menuView.setMnemonic('V');
        menuBar.add(menuView);
        JCheckBoxMenuItem menuToolBar = new JCheckBoxMenuItem("\u30c4\u30fc\u30eb\u30d0\u30fc(T)", true);
        menuToolBar.setMnemonic('T');
        menuToolBar.setActionCommand("ToolBar");
        menuToolBar.addActionListener(this);
        menuView.add(menuToolBar);
        JCheckBoxMenuItem menuStatusBar = new JCheckBoxMenuItem("\u30b9\u30c6\u30fc\u30bf\u30b9\u30d0\u30fc(S)", true);
        menuStatusBar.setMnemonic('S');
        menuStatusBar.setActionCommand("StatusBar");
        menuStatusBar.addActionListener(this);
        menuView.add(menuStatusBar);
    }

    void InitToolBar() {
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        JButton btnOpen = new JButton("\u958b\u304f");
        JButton btnSave = new JButton(".txt\u4fdd\u5b58");
        JButton btnToMM = new JButton(".mm\u4fdd\u5b58");
        btnOpen.setActionCommand("ToText");
        btnSave.setActionCommand("SaveAs");
        btnToMM.setActionCommand("ToMM");
        btnOpen.addActionListener(this);
        btnSave.addActionListener(this);
        btnToMM.addActionListener(this);
        this.toolBar.add(btnOpen);
        this.toolBar.add(btnSave);
        this.toolBar.add(btnToMM);
        this.toolBar.addSeparator();
        this.getContentPane().add((Component)this.toolBar, "North");
    }

    void InitStatusBar() {
        this.statusBar = new JLabel("\u3000");
        this.getContentPane().add((Component)this.statusBar, "South");
    }

    void InitTextArea(int width, int height) {
        this.textArea = new JTextArea();
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.textArea.setTabSize(2);
        JScrollPane scroll = new JScrollPane(this.textArea);
        scroll.setVerticalScrollBarPolicy(22);
        scroll.setPreferredSize(new Dimension(width, height));
        this.getContentPane().add((Component)scroll, "Center");
    }

    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals("New")) {
            this.OnNew();
        } else if (cmd.equals("Open")) {
            this.OnOpen();
        } else if (cmd.equals("Save")) {
            this.OnSave();
        } else if (cmd.equals("SaveMM")) {
            this.OnSaveMM();
        } else if (cmd.equals("SaveAs")) {
            this.cnt = this.getContentPane();
            String msg1 = ".txt\u5f62\u5f0f\u4fdd\u5b58\u3067\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f";
            String title1 = "\u78ba\u8a8d";
            int type1 = 0;
            int re = JOptionPane.showConfirmDialog(this.cnt, msg1, title1, type1);
            if (re == 0) {
                this.OnSaveAs();
            }
        } else if (cmd.equals("Print")) {
            this.printFile();
        } else if (cmd.equals("Exit")) {
            this.OnExit();
        } else if (cmd.equals("Cut")) {
            this.OnCut();
        } else if (cmd.equals("Copy")) {
            this.OnCopy();
        } else if (cmd.equals("Paste")) {
            this.OnPaste();
        } else if (cmd.equals("ToolBar")) {
            this.OnToolBar(((JCheckBoxMenuItem)ae.getSource()).getState());
        } else if (cmd.equals("ToMM")) {
            this.cnt = this.getContentPane();
            String msg1 = ".mm\u5f62\u5f0f\u4fdd\u5b58\u3067\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f";
            String title1 = "\u78ba\u8a8d";
            int type1 = 0;
            int re = JOptionPane.showConfirmDialog(this.cnt, msg1, title1, type1);
            if (re == 0) {
                this.OnToMM();
            }
        } else if (cmd.equals("ToText")) {
            this.OnToText();
        } else if (cmd.equals("StatusBar")) {
            this.OnStatusBar(((JCheckBoxMenuItem)ae.getSource()).getState());
        }
    }

    void OnNew() {
        this.fileChooser.setSelectedFile(null);
        this.setTitle("MMEditor-\u65b0\u898f\u6587\u66f8");
        this.textArea.setText("");
        this.statusBar.setText("  ");
    }

    void OnOpen() {
        this.statusBar.setText("  ");
        int returnVal = this.fileChooser.showOpenDialog(this);
        this.fileChooser.setCurrentDirectory(new File("."));
        FileController fct = new FileController();
        try {
            if (returnVal == 0) {
                File file = this.fileChooser.getSelectedFile();
                this.textArea.setText("");
                String s = file.getAbsolutePath();
                this.setTitle("MMEditor-" + s);
                int j = 0;
                while (j < fct.ReadFromFile(s).size()) {
                    this.textArea.append(fct.ReadFromFile(s).get(j) + "\n");
                    ++j;
                }
            }
        }
        catch (Exception ex) {
            this.statusBar.setText("\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u3051\u307e\u305b\u3093");
        }
    }

    void OnSave() {
        this.statusBar.setText("  ");
        if (this.fileChooser.getSelectedFile() == null) {
            this.OnToMM();
        } else {
            FileController fct = new FileController();
            try {
                File file = this.fileChooser.getSelectedFile();
                String s = this.textArea.getText();
                String ss = file.getAbsolutePath();
                fct.saveToFile(ss, s);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.statusBar.setText("\u30d5\u30a1\u30a4\u30eb\u3092\u4fdd\u5b58\u3067\u304d\u307e\u305b\u3093\u3002\u8a18\u6cd5\u3092\u78ba\u304b\u3081\u3066\u4e0b\u3055\u3044\u3002");
            }
        }
    }

    void OnSaveMM() {
        this.statusBar.setText("  ");
        if (this.fileChooser.getSelectedFile() == null) {
            this.OnToMM();
        } else {
            FileController fct = new FileController();
            try {
                File file = this.fileChooser.getSelectedFile();
                String s = this.textArea.getText();
                String ss = file.getAbsolutePath();
                fct.saveToMMFile1(ss, s);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.statusBar.setText("\u30d5\u30a1\u30a4\u30eb\u3092\u4fdd\u5b58\u3067\u304d\u307e\u305b\u3093\u3002\u8a18\u6cd5\u3092\u78ba\u304b\u3081\u3066\u4e0b\u3055\u3044\u3002");
            }
        }
    }

    void OnSaveAs() {
        this.statusBar.setText("  ");
        int returnVal = this.fileChooser.showSaveDialog(this);
        this.fileChooser.setCurrentDirectory(new File("."));
        FileController fct = new FileController();
        try {
            if (returnVal == 0) {
                File file = this.fileChooser.getSelectedFile();
                String s = file.getAbsolutePath();
                String ss = this.textArea.getText();
                fct.saveToFile(s, ss);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.statusBar.setText("\u30d5\u30a1\u30a4\u30eb\u3092\u4fdd\u5b58\u3067\u304d\u307e\u305b\u3093\u3002\u8a18\u6cd5\u3092\u78ba\u304b\u3081\u3066\u4e0b\u3055\u3044\u3002");
        }
    }

    private void printFile() {
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPrintable(this);
        try {
            if (pj.printDialog()) {
                pj.print();
            }
        }
        catch (PrinterException pe) {
            JOptionPane.showMessageDialog(this.statusBar, "\u30d7\u30ea\u30f3\u30c8\u30a8\u30e9\u30fc", pe.toString(), 0);
        }
    }

    public int print(Graphics g, PageFormat format, int pageIndex) {
        if (pageIndex == 0) {
            Graphics2D g2D = (Graphics2D)g;
            g2D.translate(format.getImageableX(), format.getImageableY());
            this.textArea.print(g2D);
            return 0;
        }
        return 1;
    }

    void OnExit() {
        System.exit(0);
    }

    void OnCut() {
        this.statusBar.setText("  ");
        this.OnCopy();
        this.textArea.replaceRange(null, this.textArea.getSelectionStart(), this.textArea.getSelectionEnd());
    }

    void OnCopy() {
        this.statusBar.setText("  ");
        Clipboard cb = this.getToolkit().getSystemClipboard();
        StringSelection strSel = new StringSelection(this.textArea.getSelectedText());
        cb.setContents(strSel, strSel);
    }

    void OnPaste() {
        this.statusBar.setText("  ");
        Clipboard cb = this.getToolkit().getSystemClipboard();
        Transferable data = cb.getContents(this);
        if (data != null && data.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String str = (String)data.getTransferData(DataFlavor.stringFlavor);
                this.textArea.replaceRange(str, this.textArea.getSelectionStart(), this.textArea.getSelectionEnd());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void OnToText() {
        this.statusBar.setText("  ");
        int returnVal = this.fileChooser.showOpenDialog(this);
        this.fileChooser.setCurrentDirectory(new File("."));
        FileController fct = new FileController();
        try {
            if (returnVal == 0) {
                File file = this.fileChooser.getSelectedFile();
                this.textArea.setText("");
                String s = file.getAbsolutePath();
                this.setTitle("MMEditor-" + s);
                int m = fct.ReadFromFileToTree(file).size();
                int j = 0;
                while (j < m) {
                    this.textArea.append(fct.ReadFromFileToTree(file).get(j) + "\n");
                    ++j;
                }
                fct.ReadFromFileToTree(file).clear();
            }
        }
        catch (Exception ex) {
            this.statusBar.setText("\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
        }
    }

    void OnToMM() {
        this.statusBar.setText("  ");
        int returnVal = this.fileChooser.showSaveDialog(this);
        this.fileChooser.setCurrentDirectory(new File("."));
        FileController fct = new FileController();
        try {
            if (returnVal == 0) {
                File file = this.fileChooser.getSelectedFile();
                String s = file.getAbsolutePath();
                String ss = this.textArea.getText();
                fct.saveToMMFile1(s, ss);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.statusBar.setText("\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u8a18\u6cd5\u3092\u78ba\u304b\u3081\u3066\u4e0b\u3055\u3044\u3002");
        }
    }

    void OnToolBar(boolean b) {
        this.toolBar.setVisible(b);
    }

    void OnStatusBar(boolean b) {
        this.statusBar.setVisible(b);
    }

    public static void main(String[] args) {
        new MMView();
    }
}

